#############################################################################
# LFS Lapper Multi-Page Help System by Krayy
#############################################################################
# This is a more flexible Help system that allows the addition of extra help
# descriptions without encroaching on available screen area.
#############################################################################
# Ver 1.0.1 - 15 Jan 2010 Initial release
# Ver 1.0.2 - 16 Jan 2010 Minor updates to display
# Ver 1.0.4 - 16 Feb 2010 Updated to support v 5.926b
# Ver 1.0.5 - 7 July 2010, Updated for common look & feel interface
#############################################################################

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 )
	THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH ( $command )
		CASE "!help":
			DoCifHelpGeneral(0, "gui_help_header_General");
			BREAK;
	ENDSWITCH
EndCatchEvent

CatchEvent OnLapperStart()
	# CifRegisterModule("Group_Name", "Module Name", MODULE_VERSION);
	CifRegisterModule("Help", "General", "1.01");
EndCatchEvent

Sub DoCifHelpGeneral ( $KeyFlags, $id )
	# Set default values for the module - these MUST be the same as the main Do function name
	$cifGroupName="Help";
	$cifModuleName="General";
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "_";

	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "General Help");
	openPrivButton ( $DialogPrefix . "help",$CifOrigL+1,$CifOrigT,98,6,5,-1,64,langEngine( "%{gui_help_contents_" . $cifModuleName . "}%") );
EndSub

Lang "EN" # Race Events messages
	gui_help_contents_General = "^2General Player commands"
			. "%nl%^3!cleanspb ^8- Reset this sessions PBs"
			. "%nl%^3!connected ^8- Check player status"
			# . "%nl%^3!groupqual ^8- Show group qualifying pos"
			# . "%nl%^3!hand [name] ^8- Show current handicap"
			# . "%nl%^3!hc ^8- Show all players current handicaps"
			. "%nl%^3!laps ^8- Total laps done for this car/track + session"
			# . "%nl%^3!license [name] ^8- Display license status"
			# . "%nl%^3!myconfig ^8- Configure split time display"
			. "%nl%^3!msgcfg ^8- Configure messages about great/good splits/lap"
			. "%nl%^3!mypb [cars] ^8- Show user PBs for set of cars"
			. "%nl%^3!panic ^8- Warn admins that grid is wrong"
			. "%nl%^3!plstatus X ^8- Set player status , 0 = ^2ready^8 , 1 = ^1not ready^8 , 2 = ^3spectator"
			. "%nl%^3!pos ^8- Show friendly position"
			. "%nl%^3!privatmsg ^8- Send a private message to a selected player"
			. "%nl%^3!rqual X ^8- Start qualify over X time. (no value=same length again)"
			. "%nl%^3!rrace X ^8- Start race over X laps. (no value=same length again)"
			. "%nl%^3!schedule ^8- Show schedule of next races"
			# . "%nl%^3!stats [name] ^8- Display user stats"
			# . "%nl%^3!statsqual [name] ^8- Display user stats"
			. "%nl%^3!time ^8- Server time"
			. "%nl%^3!top ^8- Show best times for current track+car(s)"
			. "%nl%^3!track ^8- Name of actual track"
			# . "%nl%^3!who ^8- Display connected user info and stats"
			. "%nl%"
			. "%nl%^2Pit Board Setup and Info"
			. "%nl%^3!pbclose ^8- Close pitboard temporary"
			. "%nl%^3!pbstart ^8- Open pitboard with stored settings"
			. "%nl%^3!pbconfig ^8- Configure pitboard"
			# . "%nl%^3!pit ^8- Pit stop info"
			. "%nl%^3!pitwindow ^8- Display pit window(s)";
EndLang
